"""
Randomly sample 100 partnet shapes and save to file
"""
import os
import random


def get_subdirectories(path):
    return [d for d in os.listdir(path) if os.path.isdir(os.path.join(path, d))]

# Path to your dataset directory
PARTNET_DIR = '/home/codeysun/git/data/PartNet/data_v0/'

# Get all subdirectories
all_dirs = get_subdirectories(PARTNET_DIR)

# Randomly select 100 directories (or less if there aren't 100)
selected_dirs = random.sample(all_dirs, min(100, len(all_dirs)))

# Save the selected directory names to a file
output_file = "selected_partnet_data.txt"
with open(output_file, "w") as f:
    for dir_name in selected_dirs:
        f.write(f"{dir_name}\n")

print(f"Selected {len(selected_dirs)} directories and saved to {output_file}")
